//Tonemap Based on Filmic Worlds
//http://filmicworlds.com/

float filmc(float x) {
float A = 0.22;
float B = 0.3;
float C = 0.15 * 1.70;
float D = 0.4 * 1.30;
float E = 0.01 * 1.47;
float F = 0.2;
return ((x * (A * x + C * B) + D * E) / (x * (A * x + B) + D * F)) - E / F;
}

vec3 U2TM(vec3 clr) {
float W = 1.3 / 1.0;
float Luma = dot(clr, vec3(0.0, 0.3, 0.3));
vec3 Chroma = clr - Luma;
clr = (Chroma * 1.70) + Luma;
  clr = vec3(filmc(clr.r), filmc(clr.g), filmc(clr.b)) / filmc(W);
return clr;
}

//Saturation By pjcozzi CesiumGS
//https://github.com/CesiumGS/cesium/blob/master/Source/Shaders/Builtin/Functions/saturation.glsl

vec3 saturation(vec3 rgb, float adjustment)
{
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    vec3 intensity = vec3(dot(rgb, W));
    return min( mix(intensity, rgb, adjustment), vec3( 1.0, 1.0, 1.0 ));
}

vec3 grayscale(vec3 tex){
tex /= 3.0;
tex = vec3(tex.r + tex.g + tex.b);
        vec3 gray = vec3(dot(vec3(0.3), tex.rgb));
        vec3 color = gray * (vec3(0.7, 0.9, 1.3) * 0.12);
        return max(gray,color);
}

vec3 czm_exposure(vec3 diffuse)
{
float gamma = 0.0;
float exposure = 1.7;
diffuse *= exposure/(1. + diffuse / exposure);
//.diffuse = pow(diffuse, vec3(1. / gamma));
return diffuse;
}

float specu(vec2 uv,float a,float b){
float specu;
specu = smoothstep(a,b,length(uv));
return specu;
}

vec3 disableAO(vec3 baseColour, vec4 vertexColour) {

    vec3 result = baseColour;

    if (vertexColour.r != vertexColour.g && vertexColour.g != vertexColour.b || vertexColour.r != vertexColour.b && vertexColour.g != vertexColour.b || vertexColour.g < vertexColour.r /* Redstone dust */) {
        if (vertexColour.a != 0.0){
            result *= normalize(vertexColour.rgb);
        }
    }
    if (vertexColour.a == 0.0){
        result *= vertexColour.rgb * 1.35 /* Brightness adjustment for leaves */ ;
    }

    return result; // Completely disable AO (with redstone dust brightness)
}