//Detection By OSBE Shaders
//https://mcpedl.com/osbes/

float detectNether(sampler2D texture1){
    float NetherDetectionPixel = texture(texture1, vec2(0.0)).r;
   
	if (NetherDetectionPixel > 0.15){
		return 1.0;
	}
    return 0.0;
}

float detectDay(sampler2D texture1){
	vec3 dayTimeDetectionPixel = texture(texture1, vec2(0.0, 1.0)).rgb;
	float dayTime = dayTimeDetectionPixel.g / dayTimeDetectionPixel.b;
	return pow(dayTime, 5.0);
}

float detectSunRize(){
	float isSunrize = dot(normalize(FOG_COLOR.rgb), vec3(1.0, 0.0, 0.0));
	return pow(isSunrize, 4.0);
}

float detectRain(){
	float isRain = 0.5 - FOG_CONTROL.r;
    return clamp(isRain * 5.0, 0.0, 1.0);
}

void detectEnvironment(out float isDay, out float isNether, out float isSunrize, sampler2D texture1){
	isDay = detectDay(texture1);
   	isNether = detectNether(texture1);
	isSunrize = detectSunRize();
}

float detectUnderwater(){
	vec3 fogColorNormalized = normalize(FOG_COLOR.rgb);
	if(fogColorNormalized.r < 0.22 
	&& fogColorNormalized.b < 0.90 && fogColorNormalized.b > 0.77
	&& fogColorNormalized.g < 0.61 && fogColorNormalized.g > 0.44){
		return 1.0;
	}
	
	return 0.0;
}