import * as Minecraft from "@minecraft/server";
import { ButtonNameBehaviorComponent, ButtonNameBehaviorTargetComponent, ButtonNameTemplate, interfaceActionForm, interfaceMessageForm, interfaceModalForm } from "../outros/gc_interface";
import { EntityUtily, NumberMaxDecimal, NumberRange, VarTag, booleanDefault } from "../outros/gc";
import { serverForm } from "../serverForm";


const items_shooter= `arrow
dragon_fireball
egg
fireball
fireworks_rocket
llama_spit
shulker_bullet
small_fireball
snowball
thrown_trident
wither_skull_dangerous
wither_skull`.split("\n");


function classic_skin_id_icon(id=0){
    const icons = [
        "minecraft/classic_skin/steve/icon",
        "minecraft/classic_skin/alex/icon",
    
        "gabriielcraft/classic_skin/skin_1/icon",
        "gabriielcraft/classic_skin/skin_2/icon",
        "gabriielcraft/classic_skin/skin_3/icon",
        "gabriielcraft/classic_skin/skin_4/icon",
        "gabriielcraft/classic_skin/skin_5/icon",
        "gabriielcraft/classic_skin/skin_6/icon",
        "gabriielcraft/classic_skin/skin_7/icon",
        "gabriielcraft/classic_skin/skin_8/icon",
        "gabriielcraft/classic_skin/skin_9/icon",
        "gabriielcraft/classic_skin/skin_10/icon",
        "gabriielcraft/classic_skin/skin_11/icon",
        "gabriielcraft/classic_skin/skin_12/icon",
        "gabriielcraft/classic_skin/skin_13/icon",
        "gabriielcraft/classic_skin/skin_14/icon",
        "gabriielcraft/classic_skin/skin_15/icon",
        "gabriielcraft/classic_skin/skin_16/icon",
        "gabriielcraft/classic_skin/skin_17/icon",
        "gabriielcraft/classic_skin/skin_18/icon",
        "gabriielcraft/classic_skin/skin_19/icon",
        "gabriielcraft/classic_skin/skin_20/icon"
    ];
    if(id>=0){
        return icons[id]
    }
    return `custom/classic_skin/skin_${Math.abs(id)}`
}


export class CustomNPC_interfaces {
    static async default(player, other){
        await new Promise(e=>e())
        let ui =new interfaceActionForm({title:"npc editor"})
        ui.button("gc.npc.interface.customizeAppearance", "textures/ui/dressing_room_customization.png", ({player, other})=>{
            this.customizeAppearance(player, other)
        })
        ui.button("gc.npc.interface.inventory", "textures/ui/inventory_icon.png", ({player, other})=>{
            this.inventory(player, other);
        })
        ui.button("gc.npc.interface.components", "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.components(player, other);
        })
        ui.button("gc.npc.interface.behaviors", "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.behaviors(player, other);
        })
        ui.button("gc.npc.interface.functions", "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.functions(player, other);
        })
        ui.button("gc.npc.interface.experimental", "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.experimental(player, other);
        })
        ui.button(`kill`, "textures/ui/barrier.png", ({player, other})=>{
            other[0].triggerEvent('gc:kill');
        })
        ui.show(player, other)
    }
    static async behaviors(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.default(player, other);
        })
        ui.button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.random_stroll", eventJSON.random_stroll), "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.behaviors_randomStroll(player, other);
        })
        ui.button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.attackable_target", eventJSON.attackable_target), "textures/ui/strength_effect.png", ({player, other})=>{
            this.behaviors_attackableTarget(player, other);
        })
        ui.button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.run_from", eventJSON.run_from), "textures/ui/speed_effect.png", ({player, other})=>{
            this.behaviors_runFrom(player, other);
        })
        ui.button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.look_at_player", eventJSON.look_at_player), "textures/ui/ender_eye.png", ({player, other})=>{
            this.behaviors_look_at_player(player, other);
        })
        ui.show(player, other);
    }
    static async behaviors_look_at_player(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let look_at_player = eventJSON.look_at_player||{"priority":0,"look_distance":6,"probability":0.1}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors(player, other); return }
            if(formValues[0]===false){
                VarTag.remove(other[0], "look_at_player")
                other[0].triggerEvent(`sync_component:look_at_player`);
                this.behaviors(player, other);
                return
            }
            look_at_player.priority=formValues[1];
            look_at_player.look_distance=NumberMaxDecimal(NumberRange(Number(formValues[2]||look_at_player.look_distance), 0, 9));
            look_at_player.probability=NumberMaxDecimal(NumberRange(Number(formValues[3]||look_at_player.probability), 0, 1), 2);
            VarTag.set(other[0], "look_at_player", look_at_player);
            other[0].triggerEvent(`sync_component:look_at_player`);
            this.behaviors(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", eventJSON.look_at_player===undefined?false:true)
        ui.slider("priority", 0, 9, 1, look_at_player.priority)
        ui.textField("look_distance", "1 ---- 9", `${look_at_player.look_distance}`)
        ui.textField("probability", "0.00 ---- 1.00", `${look_at_player.probability}`)
        ui.show(player, other);
    }
    static async behaviors_randomStroll(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let random_stroll = eventJSON.random_stroll||{priority:0}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors(player, other); return }
            if(formValues[0]===false){
                VarTag.remove(other[0], "random_stroll")
                other[0].triggerEvent(`sync_component:random_stroll`);
                this.behaviors(player, other);
                return
            }
            let result={};
            result.priority=Math.trunc(NumberRange(Number(formValues[1]), 0, 9));
            VarTag.set(other[0], "random_stroll", result);
            other[0].triggerEvent(`sync_component:random_stroll`);
            this.behaviors(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", Boolean(eventJSON.random_stroll===undefined?false:true))
        ui.slider("priority", 0, 9, 1, random_stroll.priority||0)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.behaviors(player, other);
        });
        ui.button(ButtonNameBehaviorComponent("gc.boolean.behavior", eventJSON.attackable_target), "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.behaviors_attackableTarget_behaviors(player, other);
        });
        if(eventJSON.attackable_target!==undefined)
            ui.button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.attackable_target.target_by_hurt", eventJSON.target_by_hurt), "textures/ui/sword.png", ({player, other})=>{
                this.behaviors_attackableTarget_targetByHurt(player, other);
            });
        if(eventJSON.attackable_target!==undefined)
            ui.button(ButtonNameTemplate("gc.npc.interface.behaviors.attackable_target.behavior_attack", `${eventJSON.behavior_melee_attack?"melee":eventJSON.behavior_ranged_attack?"ranged":"none"}`), `textures/ui/${eventJSON.behavior_melee_attack?"attack":eventJSON.behavior_ranged_attack?"interact":"barrier"}.png`, ({player, other})=>{
                this.behaviors_attackableTarget_behaviorAttack(player, other);
            });
        if(eventJSON.attackable_target!==undefined&&eventJSON.behavior_melee_attack!==undefined)
            ui.button(ButtonNameTemplate("gc.npc.interface.components", "damage", eventJSON, 1), "textures/ui/strength_effect.png", ({player, other})=>{
                this.behaviors_attackableTarget_damage(player, other, 1);
            });
        if(eventJSON.attackable_target!==undefined&&eventJSON.behavior_ranged_attack!==undefined)
            ui.button(ButtonNameTemplate("gc.npc.interface.behaviors.attackable_target", "shooter", eventJSON, "none"), "textures/ui/bow.png", ({player, other})=>{
                this.behaviors_attackableTarget_shooter(player, other);
            });
        if(eventJSON.attackable_target!==undefined)
            ui.button(ButtonNameBehaviorTargetComponent(eventJSON.attackable_target), `textures/ui/${eventJSON.attackable_target==="nothing"?"barrier":"creator_glyph_color"}.png`, ({player, other})=>{
                this.target(player, other, "attackable_target", ()=>this.behaviors_attackableTarget(player, other))
            });
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_behaviors(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let attackable_target = eventJSON.attackable_target||{priority:0, target:{type:"nothing",value:"nothing"}, must_see:false}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors_attackableTarget(player, other); return }
            if(formValues[0]===false){
                VarTag.remove(other[0], "attackable_target")
                VarTag.remove(other[0], "behavior_melee_attack")
                VarTag.remove(other[0], "behavior_ranged_attack")
                VarTag.remove(other[0], "shooter")
                VarTag.remove(other[0], "target_by_hurt")
                other[0].triggerEvent(`sync_component:attackable_target`);
                other[0].triggerEvent(`sync_component:behavior_melee_attack`);
                other[0].triggerEvent(`sync_component:behavior_ranged_attack`);
                other[0].triggerEvent(`sync_component:shooter`);
                other[0].triggerEvent(`sync_component:target_by_hurt`);
                this.behaviors_attackableTarget(player, other);
                return
            }
            let result={};
            result.priority=formValues[1]||attackable_target.priority;
            result.target={}
            result.target.type=attackable_target.target.type
            result.target.value=attackable_target.target.value
            result.must_see=formValues[2];
            VarTag.set(other[0], "attackable_target", result);
            other[0].triggerEvent(`sync_component:attackable_target`);
            this.behaviors_attackableTarget(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", Boolean(eventJSON.attackable_target===undefined?false:true))
        ui.slider("priority", 0, 9, 1, attackable_target.priority||0)
        ui.toggle("gc.npc.interface.behaviors.attackable_target.behavior.must_see", attackable_target.must_see||false)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_targetByHurt(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let target_by_hurt = eventJSON.target_by_hurt||{priority:0}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled){ this.behaviors_attackableTarget(player, other); return }
            target_by_hurt.priority=formValues[1];
            
            if(formValues[0])
                VarTag.set(other[0], "target_by_hurt", target_by_hurt);
            else
                VarTag.remove(other[0], "target_by_hurt")

            other[0].triggerEvent(`sync_component:target_by_hurt`);
            this.behaviors_attackableTarget(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", Boolean(eventJSON.target_by_hurt===undefined?false:true))
        ui.slider("priority", 0, 9, 1, target_by_hurt.priority||0)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_behaviorAttack(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let behavior_attack = eventJSON.behavior_melee_attack||eventJSON.behavior_ranged_attack||{attack_radius:2, cooldown_time:1}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors_attackableTarget(player, other); return }
            if(formValues[0]===0)
            {
                VarTag.remove(other[0], "behavior_melee_attack")
                VarTag.remove(other[0], "behavior_ranged_attack")
                this.behaviors_attackableTarget(player, other);
            }
            if(formValues[0]===1)
            {
                let result={};
                result.attack_radius=NumberMaxDecimal(NumberRange(Number(formValues[1]), 0, 9.9), 1);
                result.cooldown_time=NumberMaxDecimal(NumberRange(Number(formValues[2]), 0, 10), 1);
                VarTag.set(other[0], "behavior_melee_attack", result);
                VarTag.remove(other[0], "behavior_ranged_attack")
                this.behaviors_attackableTarget(player, other);
            }
            if(formValues[0]===2)
            {
                let result={};
                result.attack_radius=NumberMaxDecimal(NumberRange(Number(formValues[1]), 0, 9.9), 1);
                result.cooldown_time=NumberMaxDecimal(NumberRange(Number(formValues[2]), 0, 10), 1);
                VarTag.set(other[0], "behavior_ranged_attack", result);
                VarTag.remove(other[0], "behavior_melee_attack")
                this.behaviors_attackableTarget(player, other);
            }
            other[0].triggerEvent(`sync_component:behavior_melee_attack`);
            other[0].triggerEvent(`sync_component:behavior_ranged_attack`);

        });
        ui.dropdown("gc.npc.interface.behaviors.attackable_target.behavior_attack.type", ["gc.npc.interface.behaviors.attackable_target.behavior_attack.none", "gc.npc.interface.behaviors.attackable_target.behavior_attack.melee", "gc.npc.interface.behaviors.attackable_target.behavior_attack.ranged"], eventJSON.behavior_melee_attack?1:eventJSON.behavior_ranged_attack?2:0)
        ui.textField("gc.npc.interface.behaviors.attackable_target.behavior_attack.attack_radius", "0.0 ---- 9.9", `${behavior_attack.attack_radius}`)
        ui.textField("gc.npc.interface.behaviors.attackable_target.behavior_attack.cooldown_time", "0.0 ---- 10.0", `${behavior_attack.cooldown_time}`)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_damage(player, other, pag=1){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.behaviors_attackableTarget(player, other);
        });
        ui.textField("gc.npc.interface.components.damage", "0 --- 9999", `${eventJSON.damage>=0?eventJSON.damage:1}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "damage", NumberRange(Number(formValue), 0, 9999));
            other[0].triggerEvent(`sync_component:damage`);
        })
        ui.show(player, other);

    }
    static async behaviors_attackableTarget_shooter(player, other){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.behaviors_attackableTarget(player, other);
        });
        ui.button(`gc.npc.interface.behaviors.attackable_target.shooter.none`, "textures/ui/barrier.png", ({player, other})=>{
            VarTag.remove(other[0], "shooter");
            other[0].triggerEvent(`sync_component:shooter`);
            this.behaviors_attackableTarget(player, other);
        });
        for (let item of items_shooter){
          ui.button(`gc.npc.interface.behaviors.attackable_target.shooter.${item}`, "textures/ui/creator_glyph_color.png", ({player, other})=>{
            VarTag.set(other[0], "shooter", item);
            other[0].triggerEvent(`sync_component:shooter`);
            this.behaviors_attackableTarget(player, other);
        });
        }
        ui.show(player, other);
    }
    static async behaviors_runFrom(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui = new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.behaviors(player, other);
        });
        ui.button(ButtonNameBehaviorComponent("gc.boolean.behavior", eventJSON.run_from), "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.behaviors_runFrom_behaviors(player, other);
        });
        if(eventJSON.run_from!==undefined)
            ui.button(ButtonNameBehaviorTargetComponent(eventJSON.run_from), `textures/ui/${eventJSON.attackable_target==="nothing"?"barrier":"creator_glyph_color"}.png`, ({player, other})=>{
                this.target(player, other, "run_from", ()=>this.behaviors_runFrom(player, other))
            });
        ui.show(player, other);
    }
    static async behaviors_runFrom_behaviors(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let run_from = eventJSON.run_from||{priority:0, target:{type:"nothing",value:"nothing"}, max_dist:8}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors_runFrom(player, other); return }
            if(formValues[0]===false){
                VarTag.remove(other[0], "run_from")
                other[0].triggerEvent(`sync_component:run_from`);
                this.behaviors_runFrom(player, other);
                return
            }
            run_from.priority=formValues[1];
            run_from.max_dist=NumberMaxDecimal(NumberRange(Number(formValues[2]||run_from.max_dist), 1, 9));
            VarTag.set(other[0], "run_from", run_from);
            other[0].triggerEvent(`sync_component:run_from`);
            this.behaviors_runFrom(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", eventJSON.run_from===undefined?false:true)
        ui.slider("priority", 0, 9, 1, run_from.priority)
        ui.textField("max_dist", "1 ---- 9", `${run_from.max_dist}`)
        ui.show(player, other);
    }
    static async behaviors_sleep(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let sleep_start = eventJSON.sleep_start||{"priority":0}
        let sleep_time = eventJSON.sleep_time||[12000,12000]
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>{
            if(canceled===true){ this.behaviors(player, other); return }
            if(!formValues[0]) 
            {
                VarTag.remove(other[0], "sleep");
                VarTag.remove(other[0], "sleep_start");
                VarTag.remove(other[0], "sleep_time");
            }
            else
            {
                VarTag.set(other[0], "sleep", true);
                VarTag.set(other[0], "sleep_start", {"priority":formValues[1]});
                VarTag.set(other[0], "sleep_time", [ formValues[2], formValues[3] ]);
            }
            other[0].triggerEvent(`sync_component:sleep`);
            other[0].triggerEvent(`sync_component:sleep_time`);
            this.experimental(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", eventJSON.sleep===undefined?false:true)
        ui.slider("priority", 0, 9, 1, sleep_start.priority)
        ui.slider(">=", 0, 24000, 1000, sleep_time[0])
        ui.slider("<", 0, 24000, 1000, sleep_time[1])
        ui.show(player, other);
    }

    static async components(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.default(player, other);
        })
        .button(ButtonNameTemplate(`gc.npc.interface.components.dialogueInterface`, (eventJSON.dialogue!==undefined)?"default":(eventJSON.serverForm!==undefined)?"serverform":"none"), `textures/ui/npc_ui_true.png`, ({player, other})=>{
            this.components_dialogue(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "trade", eventJSON, "none"), "textures/ui/icon_deals.png", ({player, other})=>{
            this.components_trade(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "health", eventJSON, 2), "textures/ui/heart.png", ({player, other})=>{
            this.components_health(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "movement", eventJSON, 0.25), "textures/ui/speed_effect.png", ({player, other})=>{
            this.components_moviment(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "damage", eventJSON, 1), "textures/ui/strength_effect.png", ({player, other})=>{
            this.components_damage(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "scale", eventJSON, 1), "textures/ui/profile_new_look.png", ({player, other})=>{
            this.components_scale(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "collision_box", eventJSON, {x:0.6, y:1.7}), `textures/ui/creator_glyph_color.png`, ({player, other})=>{
            this.components_collisionBox(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.components", "family", eventJSON, "npc", ""), "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.components_family(player, other);
        })
        .show(player, other);
    }
    static async components_collisionBox(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let collision_box=eventJSON.collision_box||{x:0.6,y:1.7}
        let ui = new interfaceModalForm("", ({player, formValues, other, canceled})=>{
            if(canceled){
                this.components(player, other)
                return
            }
            let result={};
            result.x=NumberMaxDecimal(NumberRange(Number(formValues[0]), 0, 5), 1);
            result.y=NumberMaxDecimal(NumberRange(Number(formValues[1]), 0, 5), 1);
            VarTag.set(other[0], "collision_box", result);
            other[0].triggerEvent(`sync_component:collision_box`);
            this.components(player, other)
        })
        ui.textField("x:", "0.0 --- 5.0", `${collision_box.x}`)
        ui.textField("y:", "0.0 --- 5.0", `${collision_box.y}`)
        ui.show(player, other);
    }
    static async components_damage(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.damage", "0 --- 9999", `${eventJSON.damage>=0?eventJSON.damage:1}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "damage", NumberMaxDecimal(NumberRange(Number(formValue), 0, 9999)));
            other[0].triggerEvent(`sync_component:damage`);
        })
        ui.show(player, other);
    }
    static async components_dialogue(player, other){
        await new Promise(e=>e());
        let eventJSON= VarTag.getObj(other[0]);
        let serverform=eventJSON.serverForm||{id:"",attack:true,interact:false};
        new interfaceModalForm("", ({other,cancelationReason,canceled,formValues,player})=>{
            if(canceled){this.components(player, other); return}
            if(formValues[0]===0){
                if(eventJSON.serverForm!==undefined)
                    other[0].triggerEvent(`remove_component:interactServerForm`);

                VarTag.remove(other[0], "dialogue");
                VarTag.remove(other[0], "serverForm");
                other[0].triggerEvent(`sync_component:dialogue`);
            }
            if(formValues[0]===1){
                if(eventJSON.serverForm!==undefined)
                    other[0].triggerEvent(`remove_component:interactServerForm`);
                VarTag.remove(other[0], "serverForm");
                VarTag.set(other[0], "dialogue", true);
                other[0].triggerEvent(`sync_component:dialogue`);
                if(formValues[1]!="")
                    other[0].runCommand(`dialogue change @s ${formValues[1]}`);
            }
            if(formValues[0]===2){
                if(Object.getOwnPropertyNames(serverForm.prototype).indexOf(formValues[1])===-1)
                {
                    console.warn("invalid id");
                    this.components_dialogue(player, other);
                    return
                }
                VarTag.remove(other[0], "dialogue");
                other[0].triggerEvent(`sync_component:dialogue`);
                let result={
                    id:formValues[1],
                    interact:formValues[2],
                    attack:formValues[3]
                }
                VarTag.set(other[0], "serverForm", result);
                if(formValues[2])
                    other[0].triggerEvent(`add_component:interactServerForm`);
                else
                    other[0].triggerEvent(`remove_component:interactServerForm`);

            }
            this.components(player, other);
        })
        .dropdown("gc.npc.interface.components.dialogueInterface.type",["gc.npc.interface.components.dialogueInterface.none", "gc.npc.interface.components.dialogueInterface.default", "gc.npc.interface.components.dialogueInterface.serverform"], (eventJSON.dialogue!==undefined)?1:(eventJSON.serverForm!==undefined)?2:0)
        .textField("id","template", serverform.id)
        .toggle("gc.npc.interface.components.dialogueInterface.interact", serverform.interact)
        .toggle("gc.npc.interface.components.dialogueInterface.attack", serverform.attack)
        .show(player, other)
    }
    static async components_dialogue_type_default(player, other){
        await new Promise(e=>e())
        new interfaceMessageForm({"title":"warn", body:`using the default interface may cause NPC name bugs

once activated, it will only be possible to change it through the dialog interface`})
        .button("ativar", ({player, other})=>{
            other[0].triggerEvent(`gc:dialogue__default`);
            this.components_dialogue(player, other);
        })
        .button("voltar", ({player, other})=>{
            this.components_dialogue_type(player, other)
        })
        .show(player, other)
    }
    static async components_family(player, other){
        await new Promise(e=>e())
        const familys= `monster
mob
fish
bat
blaze
cat
cavespider
chicken
cod
cow
creeper
dolphin
donkey
drowned
guardian_elder
dragon
enderman
endermite
evocation_illager
fox
ghast
guardian
horse
husk
irongolem
llama
magmacube
mushroomcow
mule
npc
ocelot
panda
phantom
pig
pillager
player
polarbear
pufferfish
rabbit
salmon
sheep
shulker
silverfish
skeletonhorse
skeleton
slime
snowgolem
spider
squid
stray
tnt
tropicalfish
turtle
villager
vindicator
wandering_trader
witch
wither
wolf
zombiehorse
zombie_pigman
zombie`.split("\n");
        let ui= new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.components(player, other);
        });
        for (let family of familys){
            ui.button(`§2${family}`, "textures/ui/creator_glyph_color.png", ({player, other})=>{
                VarTag.set(other[0], "family", family);
                other[0].triggerEvent(`sync_component:family`);
                this.components(player, other);
            });
        }
        
        ui.show(player, other);
    }
    static async components_moviment(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.movement", "0.00 --- 1.00", `${eventJSON.movement>=0?eventJSON.movement:0.25}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "movement", NumberMaxDecimal(NumberRange(Number(formValue), 0, 1), 2));
            other[0].triggerEvent(`sync_component:movement`);
        })
        ui.show(player, other);
    }
    static async components_health(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.health", "1 --- 9999", `${eventJSON.health>=0?eventJSON.health:2}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "health", NumberMaxDecimal(NumberRange(Number(formValue), 1, 9999)));
            other[0].triggerEvent(`sync_component:health`);
        })
		ui.toggle({translate:"gc.npc.interface.components.health.resetToMax"}, true, ({player, other, formValue})=>{
            if(!formValue)return
			EntityUtily(other[0]).getComponent.health.resetToMaxValue()
		});
		ui.slider({translate:"gc.npc.interface.components.health.boss_bar"}, 0, 100, 1, eventJSON.boss_bar, ({player, other, formValue})=>{
            VarTag.set(other[0], "boss_bar", formValue);
            other[0].triggerEvent(`sync_component:boss_bar`);
		});
        ui.show(player, other);
    }
    static async components_scale(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.scale", "0.01 --- 9.99", `${eventJSON.scale>=0?eventJSON.scale:1}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "scale", NumberMaxDecimal(NumberRange(Number(formValue), 0.01, 9.99), 2));
            other[0].triggerEvent(`sync_component:scale`);
        })
        ui.show(player, other);
    }
    static async components_trade(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title: ""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.none`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.remove(other[0], "trade");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.custom`, `textures/ui/icon_deals.png`, ({player, other})=>{
            this.components_trade_custom(player, other);
        })
        .button(`gc.npc.interface.components.trade.farmer`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "farmer");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.fisherman`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "fisherman");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })    
        .button(`gc.npc.interface.components.trade.shepherd`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "shepherd");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.fletcher`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "fletcher");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.librarian`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "librarian");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.cartographer`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "cartographer");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.cleric`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "cleric");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.armor`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "armor");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.weapon`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "weapon");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.tool`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "tool");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.butcher`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "butcher");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.leather`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "leather");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .button(`gc.npc.interface.components.trade.mason`, `textures/ui/icon_deals.png`, ({player, other})=>{
            VarTag.set(other[0], "trade", "mason");
            other[0].triggerEvent(`sync_component:trade`);
            this.components(player, other);
        })
        .show(player, other);
    }
    static async components_trade_custom(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title: ""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.components_trade(player, other);
        })
        .button(`gc.npc.interface.components.trade.custom.new`, `textures/ui/icon_deals.png`, ({player, other})=>{
            this.components_trade_custom_new(player, other, 1);
        })
        .button(`gc.npc.interface.components.trade.custom.old`, `textures/ui/icon_deals.png`, ({player, other})=>{
            this.components_trade_custom_old(player, other, 1);
        })
        .show(player, other);
    }
    static async components_trade_custom_new(player, other, pag){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.components_trade_custom(player, other);
        });
        ui.button("gc.npc.ui.button.undo", "", ({player, other})=>{
            if(pag>1){
                this.components_trade_custom_new(player, other, pag-1);
            }else{
                this.components_trade_custom_new(player, other, pag);
            }
        });
        ui.button("gc.npc.ui.button.next", "", ({player, other})=>{
            if(pag<50){
                this.components_trade_custom_new(player, other, pag+1);
            }else{
                this.components_trade_custom_new(player, other, pag);
            }
        });
        for(let i=pag*20-20+1;i<pag*20+1;i++){
            ui.button(`Custom${i}`, "textures/ui/icon_deals.png", ({player, other})=>{
                VarTag.set(other[0], "trade", `custom${i}_new`);
                other[0].triggerEvent(`sync_component:trade`);
                this.components(player, other);
            });
        }
        ui.show(player, other);
    }
    static async components_trade_custom_old(player, other, pag){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.components_trade_custom(player, other);
        });
        ui.button("gc.npc.ui.button.undo", "", ({player, other})=>{
            if(pag>1){
                this.components_trade_custom_old(player, other, pag-1);
            }else{
                this.components_trade_custom_old(player, other, pag);
            }
        });
        ui.button("gc.npc.ui.button.next", "", ({player, other})=>{
            if(pag<50){
                this.components_trade_custom_old(player, other, pag+1);
            }else{
                this.components_trade_custom_old(player, other, pag);
            }
        });
        for(let i=pag*20-20+1;i<pag*20+1;i++){
            ui.button(`Custom${i}`, "textures/ui/icon_deals.png", ({player, other})=>{
                VarTag.set(other[0], "trade", `custom${i}_old`);
                other[0].triggerEvent(`sync_component:trade`);
                this.components(player, other);
            });
        }
        ui.show(player, other);
    }
    static async customizeAppearance(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        new interfaceActionForm({title: "npc editor"})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.default(player, other);
        })
        .button(`name: ${other[0].nameTag}`, "textures/ui/name_tag.png", ({player, other})=>{
            this.customizeAppearance_editName(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin", "textures/ui/dressing_room_skins.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.customizeAppearance.animaiton"}, {translate:`npc.animation.${(eventJSON.animation_id||0)>=0?`${eventJSON.animation_id||0}`:`custom.${Math.abs(eventJSON.animation_id)}`}`}]}, "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_animation(player, other);
        })
        .show(player, other);
    }
    static async customizeAppearance_animation(player, other){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance(player, other);
        });
        ui.button(`npc.animation.0`, `textures/ui/sidebar_icons/character_creator.png`, async ({player, other})=>{
            VarTag.set(other[0], "animation_id", 0)
            await EntityUtily(other[0]).scoreboardAsync.set("npc_animation_id", 0)
            await new Promise(e=>Minecraft.system.runTimeout(e, 1))
            other[0].triggerEvent("sync:animation_id")
            this.customizeAppearance(player, other)
        });
        ui.button(`gc.npc.interface.customizeAppearance.animaiton.custom`, "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_animation_warnCustom(player, other);
        });
        for (let i=1; i<11; i++) {
            ui.button(`npc.animation.${i}`, "textures/ui/sidebar_icons/character_creator.png", async ({player, other})=>{
                VarTag.set(other[0], "animation_id", i)
                await EntityUtily(other[0]).scoreboardAsync.set("npc_animation_id", i)
                await new Promise(e=>Minecraft.system.runTimeout(e, 1))
                other[0].triggerEvent("sync:animation_id")    
                this.customizeAppearance(player, other);
            });
        }
    
        
        ui.show(player, other);
    }
    static async customizeAppearance_animation_warnCustom(player, other){
        await new Promise(e=>e())
        new interfaceMessageForm("gc.npc.interface.warn.requiresTexture.animation.title", "gc.npc.interface.warn.requiresTexture.animation.body", ({canceled, player, other})=>{
            if(canceled) this.customizeAppearance_animation(player, other);
        })
        .button("gc.npc.interface.warn.requiresTexture.animation.button1", ({player, other})=>{
            this.customizeAppearance_animation_custom(player, other, 1);
        })
        .button("gc.npc.interface.warn.requiresTexture.animation.button2", ({player, other})=>{
            this.customizeAppearance_animation(player, other);
        })
        .show(player, other)
    }
    static async customizeAppearance_animation_custom(player, other, pag){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.customizeAppearance_animation(player, other);
        });
        ui.button(`gc.npc.interface.customizeAppearance.animaiton.custom.runID`, "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_animation_custom_runID(player, other, pag);
        });
        ui.button(`gc.npc.ui.button.undo`, "", ({player, other})=>{
            if(pag>1){
                this.customizeAppearance_animation_custom(player, other, pag-1);
            }else{
                this.customizeAppearance_animation_custom(player, other, pag);
            }
        });
        ui.button(`gc.npc.ui.button.next`, "", ({player, other})=>{
            this.customizeAppearance_animation_custom(player, other, pag+1);

        });    
        for (let i=1+pag*20-20 ;i<1+pag*20 ;i++) {
            ui.button(`npc.animation.custom.${i}`, "textures/ui/sidebar_icons/character_creator.png", async ({player, other})=>{
                VarTag.set(other[0], "animation_id", -i)
                await EntityUtily(other[0]).scoreboardAsync.set("npc_animation_id", -i)
                await new Promise(e=>Minecraft.system.runTimeout(e, 1))
                other[0].triggerEvent("sync:animation_id")    
                this.customizeAppearance(player, other);
            });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_animation_custom_runID(player, other, pag){
        await new Promise(e=>e())
        new interfaceModalForm("", ({ player, other, canceled })=>{
            if(canceled) this.customizeAppearance_animation_custom(player, other, pag)
        })
        .textField("animation:", "animation.null", "", ({formValue, player, other})=>{
            if(formValue==="")
                other[0].playAnimation("animation.null", {stopExpression:"(0.0)"} )
            else
                other[0].playAnimation(formValue, {stopExpression:"(0.0)"} )

            this.customizeAppearance(player, other)
        })
        .show(player, other)
    }
    static async customizeAppearance_customizeSkin(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin.classicSkins", "textures/ui/sidebar_icons/classic_skins.png", ({player, other})=>{
            other[0].triggerEvent('gc:skin_type__0');
            this.customizeAppearance_customizeSkin_classicSkins(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin.modelSkins", "textures/ui/sidebar_icons/classic_skins.png", ({player, other})=>{
            other[0].triggerEvent('gc:skin_type__1');
            this.customizeAppearance_customizeSkin_modelSkinId(player, other);
        })/*
        * desativado por enquanto, não sei como progredir
        .button("gc.npc.interface.customizeAppearance.customizeSkin.characterCreator", "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            other[0].triggerEvent('gc:skin_type__2');
            this.customizeAppearance_customizeSkin_characterCreator(player, other);
        })*/
        .show(player, other);
    }
    static async customizeAppearance_customizeSkin_characterCreator(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin.characterCreator.skinSelect", "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin_characterCreator_skinSelect(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin.characterCreator.editSkin", "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin(player, other);
        })
        .button("gc.npc.interface.customizeAppearance.customizeSkin.characterCreator.accessory", "textures/ui/sidebar_icons/character_creator.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin(player, other);
        })
        .show(player, other);
    }
    static async customizeAppearance_customizeSkin_characterCreator_skinSelect(player, other){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance_customizeSkin_characterCreator(player, other);
        })
        
        ui.button(`npc-classicSkinId.0`, "textures/entity/npc/minecraft/classic_skin/steve/icon", async({player, other})=>{
            await other[0].runCommandAsync(`scoreboard players set @s npc_classic_skin_id 0`);
            this.customizeAppearance_customizeSkin_characterCreator(player, other);
        })
        ui.button(`npc-classicSkinId.1` , "textures/entity/npc/minecraft/classic_skin/alex/icon", async({player, other})=>{
            await other[0].runCommandAsync(`scoreboard players set @s npc_classic_skin_id 1`);
            this.customizeAppearance_customizeSkin_characterCreator(player, other);
        })
        ui.button(`gc.npc.interface.customizeAppearance.customizeSkin.classicSkins.skinId.custom` , "textures/ui/user_icon.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId_warnCustom(player, other);
        })
    
        for (let i=2; i<22; i++) {
            ui.button(`npc-classicSkinId.${i}`, `textures/entity/npc/gabriielcraft/classic_skin/skin_${i-1}/icon`, async({player, other})=>{
                await other[0].runCommandAsync(`scoreboard players set @s npc_classic_skin_id ${i}`);
                this.customizeAppearance_customizeSkin_characterCreator(player, other);
            });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_customizeSkin_classicSkins(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance_customizeSkin(player, other);
        })
        .button( {rawtext:[{translate:"gc.npc.interface.customizeAppearance.customizeSkin.classicSkins.model"},{translate:`npc.classicSkin.model.${eventJSON.classic_skin_model||0}`}]}, `textures/entity/npc/minecraft/classic_skin/${(eventJSON.classic_skin_model===1)?"alex":"steve"}/icon`, ({player, other})=>{
            if(eventJSON.classic_skin_model===1)
                other[0].triggerEvent('property:classic_skin_model__0');
            else
                other[0].triggerEvent('property:classic_skin_model__1');
            this.customizeAppearance_customizeSkin_classicSkins(player, other);
        })
        .button( {rawtext:[{translate:"gc.npc.interface.customizeAppearance.customizeSkin.classicSkins.skinId"},{text:"§2"},{translate:`npc.classicSkin.${(eventJSON.classic_skin_id||0)>=0?(eventJSON.classic_skin_id||0):(`custom.${Math.abs(eventJSON.classic_skin_id)}`)}`}]}, `textures/entity/npc/${classic_skin_id_icon(eventJSON.classic_skin_id||0)}`, ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId(player, other);
        })
        .show(player, other);
    }
    static async customizeAppearance_customizeSkin_classicSkins_skinId(player, other){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance_customizeSkin_classicSkins(player, other);
        })
        ui.button(`npc.classicSkin.0`, "textures/entity/npc/minecraft/classic_skin/steve/icon", async({player, other})=>{
            VarTag.set(other[0], "classic_skin_id", 0);
            await EntityUtily(other[0]).scoreboardAsync.set("npc_classic_skin_id", 0);
            await new Promise(e=>Minecraft.system.runTimeout(e, 1));
            other[0].triggerEvent("sync:classic_skin_id");
            this.customizeAppearance_customizeSkin_classicSkins(player, other);
        })
        ui.button(`npc.classicSkin.1` , "textures/entity/npc/minecraft/classic_skin/alex/icon", async({player, other})=>{
            VarTag.set(other[0], "classic_skin_id", 1);
            await EntityUtily(other[0]).scoreboardAsync.set("npc_classic_skin_id", 1);
            await new Promise(e=>Minecraft.system.runTimeout(e, 1));
            other[0].triggerEvent("sync:classic_skin_id");
            this.customizeAppearance_customizeSkin_classicSkins(player, other);
        })
        ui.button(`gc.npc.interface.customizeAppearance.customizeSkin.classicSkins.skinId.custom` , "textures/ui/user_icon.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId_warnCustom(player, other);
        })
    
        for (let i=2; i<22; i++) {
            ui.button(`npc.classicSkin.${i}`, `textures/entity/npc/gabriielcraft/classic_skin/skin_${i-1}/icon`, async({player, other})=>{
                VarTag.set(other[0], "classic_skin_id", i);
                await EntityUtily(other[0]).scoreboardAsync.set("npc_classic_skin_id", i);
                await new Promise(e=>Minecraft.system.runTimeout(e, 1));
                other[0].triggerEvent("sync:classic_skin_id");
                this.customizeAppearance_customizeSkin_classicSkins(player, other);
            });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_customizeSkin_classicSkins_skinId_warnCustom(player, other){
        await new Promise(e=>e())
        new interfaceMessageForm("gc.npc.interface.warn.requiresTexture.skinId.title", "gc.npc.interface.warn.requiresTexture.skinId.body", ({canceled, player, other})=>{
            if(canceled) this.customizeAppearance_customizeSkin_classicSkins_skinId(player, other);
        })
        .button("gc.npc.interface.warn.requiresTexture.skinId.button1", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId_custom(player, other, 1);
        })
        .button("gc.npc.interface.warn.requiresTexture.skinId.button2", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId(player, other);
        })
        .show(player, other)
    }
    static async customizeAppearance_customizeSkin_classicSkins_skinId_custom(player, other, pag){
        await new Promise(e=>e())
        let ui = new interfaceActionForm({title:""})
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId(player, other);
        });

        ui.button(`gc.npc.ui.button.undo`, "", ({player, other})=>{
            if(pag>1){
                this.customizeAppearance_customizeSkin_classicSkins_skinId_custom(player, other, pag-1);
            }else{
                this.customizeAppearance_customizeSkin_classicSkins_skinId_custom(player, other, pag);
            }
        });

        ui.button(`gc.npc.ui.button.next`, "", ({player, other})=>{
            this.customizeAppearance_customizeSkin_classicSkins_skinId_custom(player, other, pag+1);
        });
        
        for (let i=1+pag*20-20;i<1+pag*20;i++) {
          ui.button(`npc.classicSkin.custom.${i}`, `textures/entity/npc/custom/classic_skin/skin_${i}`, async({player, other})=>{
            VarTag.set(other[0], "classic_skin_id", -i);
            await EntityUtily(other[0]).scoreboardAsync.set("npc_classic_skin_id", -i);
            await new Promise(e=>Minecraft.system.runTimeout(e, 1));
            other[0].triggerEvent("sync:classic_skin_id");
            this.customizeAppearance_customizeSkin_classicSkins(player, other);
          });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_customizeSkin_modelSkinId(player, other){
        await new Promise(e=>e())
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin(player, other);
        });
        ui.button(`gc.npc.interface.customizeAppearance.customizeSkin.modelSkins.custom` , "textures/ui/user_icon.png", ({player, other})=>{
            this.customizeAppearance_customizeSkin_modelSkinId_warnCustom(player, other);
        });
        
        for (let i=0; i<14; i++) {
            ui.button(`npc.modelSkin.${i}`, `models/entity/minecraft/model_${i}/icon`, async({player, other})=>{
                VarTag.set(other[0], "model_skin_id", i);
                await EntityUtily(other[0]).scoreboardAsync.set("npc_model_skin_id", i);
                await new Promise(e=>Minecraft.system.runTimeout(e, 1));
                other[0].triggerEvent("sync:model_skin_id");
                this.customizeAppearance_customizeSkin(player, other);
            });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_customizeSkin_modelSkinId_warnCustom(player, other){
        await new Promise(e=>e())
        new interfaceMessageForm("gc.npc.interface.warn.requiresTexture.modelSkinId.title", "gc.npc.interface.warn.requiresTexture.modelSkinId.body", ({canceled, player, other})=>{
            if(canceled) this.customizeAppearance_customizeSkin_modelSkinId(player, other);
        })
        .button("gc.npc.interface.warn.requiresTexture.modelSkinId.button1", ({player, other})=>{
            this.customizeAppearance_customizeSkin_modelSkinId_custom(player, other, 1);
        })
        .button("gc.npc.interface.warn.requiresTexture.modelSkinId.button2", ({player, other})=>{
            this.customizeAppearance_customizeSkin_modelSkinId(player, other);
        })
        .show(player, other)
    }
    static async customizeAppearance_customizeSkin_modelSkinId_custom(player, other, pag){
        await new Promise(e=>e())
        let ui = new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.customizeAppearance_customizeSkin_modelSkinId(player, other);
        });
        ui.button(`gc.npc.ui.button.undo`, "", ({player, other})=>{
            if(pag>1){
                this.customizeAppearance_customizeSkin_modelSkinId_custom(player, other, pag-1);
            }else{
                this.customizeAppearance_customizeSkin_modelSkinId_custom(player, other, pag);
            }
        });
        ui.button(`gc.npc.ui.button.next`, "", ({player, other})=>{
            this.customizeAppearance_customizeSkin_modelSkinId_custom(player, other, pag+1);
        });
        
        for (let i=1+pag*20-20;i<1+pag*20;i++) {
          ui.button(`npc.modelSkin.custom.${i}`, `models/entity/custom/model_${i}/skin`, async({player, other})=>{
            VarTag.set(other[0], "model_skin_id", -i);
            await EntityUtily(other[0]).scoreboardAsync.set("npc_model_skin_id", -i);
            await new Promise(e=>Minecraft.system.runTimeout(e, 1));
            other[0].triggerEvent("sync:model_skin_id");
            this.customizeAppearance_customizeSkin(player, other);
          });
        }
        
        ui.show(player, other);
    }
    static async customizeAppearance_editName(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("teste", ({player, other})=>{
            this.customizeAppearance(player, other);
        })
        .textField("name:", other[0].nameTag, other[0].nameTag, ({player, other, formValue})=>{
            other[0].nameTag=formValue;
        })
        .show(player, other)
    }
    static async experimental(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.default(player, other);
        })
        .button(ButtonNameBehaviorComponent("gc.npc.interface.behaviors.sleep", eventJSON.sleep_start), "textures/ui/speed_effect.png", ({player, other})=>{
            this.behaviors_sleep(player, other);
        })
        .button(`gc.npc.ui.button.transferNPC`, "textures/ui/backup_replace.png", ({player, other})=>{
            this.transferNPC(player, other);
        })
            
    
        .show(player, other);
    }
    static async transferNPC(player, other){
        await new Promise(e=>e())
        let ui=new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.experimental(player, other);
        });
        ui.button(`gc.npc.ui.button.transferNPC.save`, "textures/ui/backup_replace.png", ({player, other})=>{
            this.transferNPC_save(player, other);
        });
        ui.button(`gc.npc.ui.button.transferNPC.load`, "textures/ui/color_plus.png", ({player, other})=>{
            this.transferNPC_load(player, other);
        });


        ui.show(player, other);
    }
    static async transferNPC_save(player, other){
        await new Promise(e=>e())
        let ui=new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.transferNPC(player, other);
        });
		
		for(let i=1;i<11;i++){
			ui.button(`gc.npc.ui.button.transferNPC.save${i}`, "textures/ui/backup_replace.png", ({player, other})=>{
				this.transferNPC(player, other);
				other[0].runCommandAsync(`structure save CustomNPC_Save${i} ~~~ ~~~ true disk false`);
			});
		}


        ui.show(player, other);
    }
    static async transferNPC_load(player, other){
        await new Promise(e=>e())
        let ui=new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.transferNPC(player, other);
        });
		
		for(let i=1;i<11;i++){
			ui.button(`gc.npc.ui.button.transferNPC.load${i}`, "textures/ui/color_plus.png", ({player, other})=>{
                let location={
                    x: other[0].location.x,
                    y: other[0].location.y,
                    z: other[0].location.z
                }
				other[0].triggerEvent(`event:despawn`);
				player.dimension.runCommandAsync(`structure load CustomNPC_Save${i} ${location.x} ${location.y} ${location.z} 0_degrees none true false true`);
			});
		}
        ui.show(player, other);
    }
    static async functions(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let attackable_target= eventJSON.attackable_target||{priority:0, target:{type:"nothing",value:"nothing"}, must_see:false};
        let behavior_attack = eventJSON.behavior_ranged_attack
        let shooter = eventJSON.shooter
        let test_follow_player= (attackable_target.target.value!=="player")? false : (behavior_attack===undefined)? false : shooter===undefined? true : false

        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.default(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.functions", "immortality", eventJSON, false, "gc.boolean."), "textures/ui/heart.png", ({player, other})=>{
            VarTag.set(other[0], "immortality", !booleanDefault(eventJSON.immortality, false));
            other[0].triggerEvent(`sync_component:immortality`);
            this.functions(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.functions", "show_name", eventJSON, false, "gc.boolean."), "textures/ui/name_tag.png", ({player, other})=>{
            VarTag.set(other[0], "show_name", !booleanDefault(eventJSON.show_name, false));
            other[0].triggerEvent(`sync_component:show_name`);
            this.functions(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.functions.follow_player"}, {translate:`gc.boolean.${test_follow_player}`}]}, "textures/ui/sprint.png", ({player, other})=>{
            this.functions_followPlayer(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.functions", "pushable", eventJSON, true, "gc.boolean."), "textures/ui/armor_stand.png", ({player, other})=>{
            VarTag.set(other[0], "pushable", !booleanDefault(eventJSON.pushable, true));
            other[0].triggerEvent(`sync_component:pushable`);
            this.functions(player, other);
        })
        /* tirado temporariamente
        .button(`gc.npc.interface.functions.team__${eventJSON.team||"none"}`, "textures/ui/dressing_room_skins.png", ({player, other})=>{
            this.functions_team(player, other);
        })
         */
        .show(player, other);
    }
    static async functions_followPlayer(player, other){
        let warn_body_enable= {
            rawtext:[
                { translate:"gc.npc.interface.edited_list" },
                { text:"\n" },
                { translate:"gc.npc.interface.behaviors.attackable_target" }, { translate:"gc.npc.interface.target.family.player" }, { text:"§r" },
                { text:"\n" },
                { translate:"gc.npc.interface.behaviors.attackable_target.behavior_attack" }, { translate:"gc.npc.interface.behaviors.attackable_target.behavior_attack.ranged" }, { text:"§r" },
                { text:"\n" },
                { translate:"gc.npc.interface.behaviors.attackable_target.shooter" }, { translate:"gc.npc.interface.behaviors.attackable_target.shooter.none" }, { text:"§r" }
            ]
        }
        let warn_body_disable= {
            rawtext:[
                { translate:"gc.npc.interface.edited_list" },
                { text:"\n" },
                { translate:"gc.npc.interface.behaviors.attackable_target" }, { translate:"gc.boolean.behavior.disable" }
            ]
        }
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let attackable_target= eventJSON.attackable_target||{priority:0, target:{type:"nothing",value:"nothing"}, must_see:false};
        let behavior_attack = eventJSON.behavior_melee_attack||eventJSON.behavior_ranged_attack||{attack_radius:2, cooldown_time:1}
        let behavior_ranged_attack = eventJSON.behavior_ranged_attack
        let shooter = eventJSON.shooter
        let test_follow_player= (attackable_target.target.value!=="player")? false : (behavior_ranged_attack===undefined)? false : shooter===undefined? true : false
        let warn_body= test_follow_player? warn_body_disable : warn_body_enable

        new interfaceMessageForm("gc.npc.interface.warn", warn_body)
        .button("gc.npc.interface.change", ({player, other})=>{
            if(test_follow_player){
                VarTag.remove(other[0], "attackable_target")
                VarTag.remove(other[0], "behavior_melee_attack")
                VarTag.remove(other[0], "behavior_ranged_attack")
                VarTag.remove(other[0], "shooter")
                VarTag.remove(other[0], "target_by_hurt")
                other[0].triggerEvent(`sync_component:attackable_target`);
                other[0].triggerEvent(`sync_component:behavior_melee_attack`);
                other[0].triggerEvent(`sync_component:behavior_ranged_attack`);
                other[0].triggerEvent(`sync_component:shooter`);
                other[0].triggerEvent(`sync_component:target_by_hurt`);
                return
            }
            //target
            attackable_target.target.type="family"
            attackable_target.target.value="player"
            VarTag.set(other[0], "attackable_target", attackable_target)
            other[0].triggerEvent(`sync_component:attackable_target`);
            //behavior attack
            VarTag.set(other[0], "behavior_ranged_attack", behavior_attack);
            VarTag.remove(other[0], "behavior_melee_attack")
            other[0].triggerEvent(`sync_component:behavior_ranged_attack`);
            other[0].triggerEvent(`sync_component:behavior_melee_attack`);
            //shooter
            VarTag.remove(other[0], "shooter");
            other[0].triggerEvent(`sync_component:shooter`);

            this.functions(player, other)
        })
        .button("gc.npc.interface.back", ({other, player})=>{
            this.functions(player, other)
        })
        .show(player, other)
    }
    static async functions_team(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.functions(player, other);
        })
        .button(`gc.npc.interface.functions.team.none`, "textures/ui/barrier.png", ({player, other})=>{
          other[0].triggerEvent(`gc:team__none`);
          this.functions(player, other);
        })
        .button(`gc.npc.interface.functions.team.red`, "textures/ui/red.png", ({player, other})=>{
          other[0].triggerEvent(`gc:team__red`);
          this.functions(player, other);
        })
        .button(`gc.npc.interface.functions.team.blue`, "textures/ui/blue.png", ({player, other})=>{
          other[0].triggerEvent(`gc:team__blue`);
          this.functions(player, other);
        })
        .button(`gc.npc.interface.functions.team.green`, "textures/ui/green.png", ({player, other})=>{
          other[0].triggerEvent(`gc:team__green`);
          this.functions(player, other);
        })
        .button(`gc.npc.interface.functions.team.yellow`, "textures/ui/yellow.png", ({player, other})=>{
          other[0].triggerEvent(`gc:team__yellow`);
          this.functions(player, other);
        })
            
    
        .show(player, other);
    }
    static async inventory(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let equipment={
            mainhand:EntityUtily(other[0]).equipment.getEquipmentSlot("mainhand").typeId||"§4none",
            head:EntityUtily(other[0]).equipment.getEquipmentSlot("head").typeId||"§4none",
            chest:EntityUtily(other[0]).equipment.getEquipmentSlot("chest").typeId||"§4none",
            legs:EntityUtily(other[0]).equipment.getEquipmentSlot("legs").typeId||"§4none",
            feet:EntityUtily(other[0]).equipment.getEquipmentSlot("feet").typeId||"§4none"
        }
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.default(player, other);
        })
        .button(ButtonNameTemplate("gc.npc.interface.inventory", "inventory", eventJSON, false, "gc.boolean."), "textures/ui/inventory_icon.png", ({player, other})=>{
            VarTag.set(other[0], "inventory", !booleanDefault(eventJSON.inventory, false));
            other[0].triggerEvent(`sync_component:inventory`);
            this.inventory(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.inventory.mainhand"}, {text:`§2${equipment.mainhand}`}]}, "textures/ui/attack.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.inventory.head"}, {text:`§2${equipment.head}`}]}, "textures/ui/npc_armor_slot_helmet.png", ({player, other})=>{
          this.inventory_head(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.inventory.chest"}, {text:`§2${equipment.chest}`}]}, "textures/ui/npc_armor_slot_chestplate.png", ({player, other})=>{
          this.inventory_chest(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.inventory.legs"}, {text:`§2${equipment.legs}`}]}, "textures/ui/npc_armor_slot_leggings.png", ({player, other})=>{
          this.inventory_legs(player, other);
        })
        .button({rawtext:[{translate:"gc.npc.interface.inventory.feet"}, {text:`§2${equipment.feet}`}]}, "textures/ui/npc_armor_slot_boots.png", ({player, other})=>{
          this.inventory_feet(player, other);
        })
    
        .show(player, other);
    }
    static async inventory_mainhand(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory(player, other);
        })
        .button(`gc.npc.interface.inventory.put_id`, "textures/ui/magnifyingGlass.png", ({player, other})=>{
          this.inventory_mainhand_putID(player, other);
        })
        .button(`gc.npc.interface.inventory.mainhand.swords`, "textures/ui/sword.png", ({player, other})=>{
          this.inventory_mainhand_swords(player, other);
        })
        .button(`gc.npc.interface.inventory.mainhand.pickaxes`, "textures/ui/iron_pickaxe.png", ({player, other})=>{
          this.inventory_mainhand_pickaxes(player, other);
        })
        .button(`gc.npc.interface.inventory.mainhand.axes`, "textures/ui/iron_axe.png", ({player, other})=>{
          this.inventory_mainhand_axes(player, other);
        })
        .button(`gc.npc.interface.inventory.mainhand.shovels`, "textures/ui/iron_shovel.png", ({player, other})=>{
          this.inventory_mainhand_shovels(player, other);
        })
        .button(`gc.npc.interface.inventory.mainhand.hoes`, "textures/ui/iron_hoe.png", ({player, other})=>{
          this.inventory_mainhand_hoes(player, other);
        })
    
    
        .show(player, other);
    }
    static async inventory_mainhand_putID(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("", ({player, other})=>{
            this.inventory(player, other)
        })
        .textField("id:", "minecraft:air", EntityUtily(other[0]).equipment.getEquipmentSlot("mainhand").typeId, ({formValue, player, other})=>{
            if(formValue==="")
                EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("air", 1));
            else
                EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack(formValue, 1));
            this.inventory(player, other);
        })
        .show(player, other)
    }
    static async inventory_mainhand_swords(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button(`item.wooden_sword.name`, "textures/items/wood_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("wooden_sword", 1));
            this.inventory(player, other);
        })
        .button(`item.stone_sword.name`, "textures/items/stone_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("stone_sword", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_sword.name`, "textures/items/iron_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("iron_sword", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_sword.name`, "textures/items/gold_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("golden_sword", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_sword.name`, "textures/items/diamond_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("diamond_sword", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_sword.name`, "textures/items/netherite_sword.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("netherite_sword", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_mainhand_pickaxes(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button(`item.wooden_pickaxe.name`, "textures/items/wood_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("wooden_pickaxe", 1));
            this.inventory(player, other);
        })
        .button(`item.stone_pickaxe.name`, "textures/items/stone_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("stone_pickaxe", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_pickaxe.name`, "textures/items/iron_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("iron_pickaxe", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_pickaxe.name`, "textures/items/gold_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("golden_pickaxe", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_pickaxe.name`, "textures/items/diamond_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("diamond_pickaxe", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_pickaxe.name`, "textures/items/netherite_pickaxe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("netherite_pickaxe", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_mainhand_axes(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button(`item.wooden_axe.name`, "textures/items/wood_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("wooden_axe", 1));
            this.inventory(player, other);
        })
        .button(`item.stone_axe.name`, "textures/items/stone_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("stone_axe", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_axe.name`, "textures/items/iron_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("iron_axe", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_axe.name`, "textures/items/gold_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("golden_axe", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_axe.name`, "textures/items/diamond_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("diamond_axe", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_axe.name`, "textures/items/netherite_axe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("netherite_axe", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_mainhand_shovels(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button(`item.wooden_shovel.name`, "textures/items/wood_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("wooden_shovel", 1));
            this.inventory(player, other);
        })
        .button(`item.stone_shovel.name`, "textures/items/stone_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("stone_shovel", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_shovel.name`, "textures/items/iron_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("iron_shovel", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_shovel.name`, "textures/items/gold_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("golden_shovel", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_shovel.name`, "textures/items/diamond_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("diamond_shovel", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_shovel.name`, "textures/items/netherite_shovel.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("netherite_shovel", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_mainhand_hoes(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory_mainhand(player, other);
        })
        .button(`item.wooden_hoe.name`, "textures/items/wood_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("wooden_hoe", 1));
            this.inventory(player, other);
        })
        .button(`item.stone_hoe.name`, "textures/items/stone_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("stone_hoe", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_hoe.name`, "textures/items/iron_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("iron_hoe", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_hoe.name`, "textures/items/gold_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("golden_hoe", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_hoe.name`, "textures/items/diamond_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("diamond_hoe", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_hoe.name`, "textures/items/netherite_hoe.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("mainhand", new Minecraft.ItemStack("netherite_hoe", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_head(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory(player, other);
        })
        .button(`gc.npc.interface.inventory.put_id`, "textures/ui/magnifyingGlass.png", ({player, other})=>{
          this.inventory_head_putID(player, other);
        })
        .button(`item.leather_helmet.name`, "textures/items/leather_helmet", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("leather_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.chainmail_helmet.name`, "textures/items/chainmail_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("chainmail_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_helmet.name`, "textures/items/iron_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("iron_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_helmet.name`, "textures/items/gold_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("golden_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_helmet.name`, "textures/items/diamond_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("diamond_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_helmet.name`, "textures/items/netherite_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("netherite_helmet", 1));
            this.inventory(player, other);
        })
        .button(`item.turtle_helmet.name`, "textures/items/turtle_helmet.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("turtle_helmet", 1));
            this.inventory(player, other);
        })
        .button(`tile.carved_pumpkin.name`, "textures/blocks/pumpkin_face_off.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("carved_pumpkin", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_head_putID(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("", ({player, other})=>{
            this.inventory(player, other)
        })
        .textField("id:", "minecraft:air", EntityUtily(other[0]).equipment.getEquipmentSlot("head").typeId, ({formValue,player})=>{
            if(formValue==="")
                EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack("air", 1));
            else
                EntityUtily(other[0]).equipment.setEquipment("head", new Minecraft.ItemStack(formValue, 1));
            this.inventory(player, other);
        })
        .show(player, other)
    }
    static async inventory_chest(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory(player, other);
        })
        .button(`gc.npc.interface.inventory.put_id`, "textures/ui/magnifyingGlass.png", ({player, other})=>{
          this.inventory_chest_putID(player, other);
        })
        .button(`item.leather_chestplate.name`, "textures/items/leather_chestplate", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("leather_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.chainmail_chestplate.name`, "textures/items/chainmail_chestplate.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("chainmail_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_chestplate.name`, "textures/items/iron_chestplate.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("iron_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_chestplate.name`, "textures/items/gold_chestplate.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("golden_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_chestplate.name`, "textures/items/diamond_chestplate.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("diamond_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_chestplate.name`, "textures/items/netherite_chestplate.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("netherite_chestplate", 1));
            this.inventory(player, other);
        })
        .button(`item.elytra.name`, "textures/items/elytra.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("elytra", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_chest_putID(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("", ({player, other})=>{
            this.inventory(player, other)
        })
        .textField("id:", "minecraft:air", EntityUtily(other[0]).equipment.getEquipmentSlot("chest").typeId, ({formValue,player})=>{
            if(formValue==="")
                EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack("air", 1));
            else
                EntityUtily(other[0]).equipment.setEquipment("chest", new Minecraft.ItemStack(formValue, 1));
            this.inventory(player, other);
        })
        .show(player, other)
    }
    static async inventory_legs(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory(player, other);
        })
        .button(`gc.npc.interface.inventory.put_id`, "textures/ui/magnifyingGlass.png", ({player, other})=>{
          this.inventory_legs_putID(player, other);
        })
        .button(`item.leather_leggings.name`, "textures/items/leather_leggings", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("leather_leggings", 1));
            this.inventory(player, other);
        })
        .button(`item.chainmail_leggings.name`, "textures/items/chainmail_leggings.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("chainmail_leggings", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_leggings.name`, "textures/items/iron_leggings.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("iron_leggings", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_leggings.name`, "textures/items/gold_leggings.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("golden_leggings", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_leggings.name`, "textures/items/diamond_leggings.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("diamond_leggings", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_leggings.name`, "textures/items/netherite_leggings.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("netherite_leggings", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_legs_putID(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("", ({player, other})=>{
            this.inventory(player, other)
        })
        .textField("id:", "minecraft:air", EntityUtily(other[0]).equipment.getEquipmentSlot("legs").typeId, ({formValue,player})=>{
            if(formValue==="")
                EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack("air", 1));
            else
                EntityUtily(other[0]).equipment.setEquipment("legs", new Minecraft.ItemStack(formValue, 1));
            this.inventory(player, other);
        })
        .show(player, other)
    }
    static async inventory_feet(player, other){
        await new Promise(e=>e())
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
          this.inventory(player, other);
        })
        .button(`gc.npc.interface.inventory.put_id`, "textures/ui/magnifyingGlass.png", ({player, other})=>{
          this.inventory_feet_putID(player, other);
        })
        .button(`item.leather_boots.name`, "textures/items/leather_boots", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("leather_boots", 1));
            this.inventory(player, other);
        })
        .button(`item.chainmail_boots.name`, "textures/items/chainmail_boots.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("chainmail_boots", 1));
            this.inventory(player, other);
        })
        .button(`item.iron_boots.name`, "textures/items/iron_boots.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("iron_boots", 1));
            this.inventory(player, other);
        })
        .button(`item.golden_boots.name`, "textures/items/gold_boots.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("golden_boots", 1));
            this.inventory(player, other);
        })
        .button(`item.diamond_boots.name`, "textures/items/diamond_boots.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("diamond_boots", 1));
            this.inventory(player, other);
        })
        .button(`item.netherite_boots.name`, "textures/items/netherite_boots.png", ({player, other})=>{
            EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("netherite_boots", 1));
            this.inventory(player, other);
        })
        .show(player, other);
    }
    static async inventory_feet_putID(player, other){
        await new Promise(e=>e())
        new interfaceModalForm("", ({player, other})=>{
            this.inventory(player, other)
        })
        .textField("id:", "minecraft:air", EntityUtily(other[0]).equipment.getEquipmentSlot("feet").typeId, ({formValue,player,ui})=>{
            if(formValue==="")
                EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack("air", 1));
            else
                EntityUtily(other[0]).equipment.setEquipment("feet", new Minecraft.ItemStack(formValue, 1));
            this.inventory(player, other);
        })
        .show(player, other)
    }
    static async target(player, other, event, back){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        new interfaceActionForm({title:""})
        .button("gc.npc.interface.back", "textures/ui/BackArrow.png", ()=>{
            back()
        })
        .button(`gc.npc.interface.target.nothing`, "textures/ui/barrier.png", ({player,other})=>{
            eventJSON[event].target.type= "nothing"
            eventJSON[event].target.value= "nothing"
            VarTag.set(other[0], event, eventJSON[event])
            other[0].triggerEvent(`sync_component:${event}`);
            back()
        })
        .button(`gc.npc.interface.target.all`, "textures/ui/creator_glyph_color.png", ({player,other})=>{
            eventJSON[event].target.type= "all"
            eventJSON[event].target.value= "all"
            VarTag.set(other[0], event, eventJSON[event])
            other[0].triggerEvent(`sync_component:${event}`);
            back()
        })
        .button("gc.npc.interface.target.family", "textures/ui/creator_glyph_color.png", ({player,other})=>{
            this.target_family(player, other, event, back);
        })
        .button("gc.npc.interface.target.tag", "textures/ui/name_tag.png", ({player,other})=>{
            this.target_tag(player, other, event, back);
        })
        .show(player, other)
    }
    static async target_family(player, other, event, back){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        const targets= `monster
mob
fish
bat
blaze
cat
cavespider
chicken
cod
cow
creeper
dolphin
donkey
drowned
guardian_elder
dragon
enderman
endermite
evocation_illager
fox
ghast
guardian
horse
husk
irongolem
llama
magmacube
mushroomcow
mule
npc
ocelot
panda
phantom
pig
pillager
player
polarbear
pufferfish
rabbit
salmon
sheep
shulker
silverfish
skeletonhorse
skeleton
slime
snowgolem
spider
squid
stray
tnt
tropicalfish
turtle
villager
vindicator
wandering_trader
witch
wither
wolf
zombiehorse
zombie_pigman
zombie`.split("\n");
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player,ui})=>{
            this.target(player, other, event, back)
        })
        for(let target of targets){
            ui.button(`gc.npc.interface.target.family.${target}`, "textures/ui/creator_glyph_color.png", ({player,ui})=>{
                eventJSON[event].target.type="family"
                eventJSON[event].target.value=target
                VarTag.set(other[0], event, eventJSON[event])
                other[0].triggerEvent(`sync_component:${event}`);
                back()    
            })
        }
        ui.show(player, other)
    }
    static async target_tag(player, other, event, back){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceActionForm({title:""});
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player,ui})=>{
            this.target(player, other, event, back)
        })
        for(let i=0;i<100;i++){
            ui.button(`tag${i}`, "textures/ui/name_tag.png", ({player,ui})=>{
                eventJSON[event].target.type="tag"
                eventJSON[event].target.value=`tag${i}`
                VarTag.set(other[0], event, eventJSON[event])
                other[0].triggerEvent(`sync_component:${event}`);
                back()
            })
        }
        ui.show(player, other)
    }
}

export class CustomNPC_high_interfaces extends CustomNPC_interfaces{
}
export class CustomNPC_medium_interfaces extends CustomNPC_interfaces{
    static async behaviors_look_at_player(player, other)
    {
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let look_at_player = eventJSON.look_at_player||{"priority":0,"look_distance":6,"probability":0.1}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>
        {
            if(canceled===true){ this.behaviors(player, other); return }
            if(formValues[0]===false)
            {
                VarTag.remove(other[0], "look_at_player")
                other[0].triggerEvent(`sync_component:look_at_player`);
                this.behaviors(player, other);
                return
            }
            look_at_player.priority=formValues[1];
            look_at_player.look_distance=NumberMaxDecimal(NumberRange(Number(formValues[2]||look_at_player.look_distance), 0, 8));
            look_at_player.probability=NumberMaxDecimal(NumberRange(Number(formValues[3]||look_at_player.probability), 0, 1), 1);
            VarTag.set(other[0], "look_at_player", look_at_player);
            other[0].triggerEvent(`sync_component:look_at_player`);
            this.behaviors(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", eventJSON.look_at_player===undefined?false:true)
        ui.slider("priority", 0, 5, 1, look_at_player.priority)
        ui.textField("look_distance", "1 ---- 8", `${look_at_player.look_distance}`)
        ui.textField("probability", "0.0 ---- 1.0", `${look_at_player.probability}`)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_behaviors(player, other)
    {
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let attackable_target = eventJSON.attackable_target||{priority:0, target:{type:"nothing",value:"nothing"}, must_see:false}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>
        {
            if(canceled===true){ this.behaviors_attackableTarget(player, other); return }
            if(formValues[0]===false)
            {
                VarTag.remove(other[0], "attackable_target")
                VarTag.remove(other[0], "behavior_melee_attack")
                VarTag.remove(other[0], "behavior_ranged_attack")
                VarTag.remove(other[0], "shooter")
                VarTag.remove(other[0], "target_by_hurt")
                other[0].triggerEvent(`sync_component:attackable_target`);
                other[0].triggerEvent(`sync_component:behavior_melee_attack`);
                other[0].triggerEvent(`sync_component:behavior_ranged_attack`);
                other[0].triggerEvent(`sync_component:shooter`);
                other[0].triggerEvent(`sync_component:target_by_hurt`);
                this.behaviors_attackableTarget(player, other);
                return
            }
            let result={};
            result.priority=formValues[1]||attackable_target.priority;
            result.target={}
            result.target.type=attackable_target.target.type
            result.target.value=attackable_target.target.value
            result.must_see=formValues[2];
            VarTag.set(other[0], "attackable_target", result);
            other[0].triggerEvent(`sync_component:attackable_target`);
            this.behaviors_attackableTarget(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", Boolean(eventJSON.attackable_target===undefined?false:true))
        ui.slider("priority", 0, 5, 1, attackable_target.priority||0)
        ui.toggle("gc.npc.interface.behaviors.attackable_target.behavior.must_see", attackable_target.must_see||false)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_targetByHurt(player, other)
    {
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let target_by_hurt = eventJSON.target_by_hurt||{priority:0}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>
        {
            if(canceled){ this.behaviors_attackableTarget(player, other); return }
            target_by_hurt.priority=formValues[1];
            
            if(formValues[0])
                VarTag.set(other[0], "target_by_hurt", target_by_hurt);
            else
                VarTag.remove(other[0], "target_by_hurt")

            other[0].triggerEvent(`sync_component:target_by_hurt`);
            this.behaviors_attackableTarget(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", Boolean(eventJSON.target_by_hurt===undefined?false:true))
        ui.slider("priority", 0, 5, 1, target_by_hurt.priority||0)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_behaviorAttack(player, other)
    {
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let behavior_attack = eventJSON.behavior_melee_attack||eventJSON.behavior_ranged_attack||{attack_radius:2, cooldown_time:1}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>
        {
            if(canceled===true){ this.behaviors_attackableTarget(player, other); return }
            if(formValues[0]===0)
            {
                VarTag.remove(other[0], "behavior_melee_attack")
                VarTag.remove(other[0], "behavior_ranged_attack")
                this.behaviors_attackableTarget(player, other);
            }
            if(formValues[0]===1)
            {
                let result={};
                result.attack_radius=NumberMaxDecimal(NumberRange(Number(formValues[1]), 0, 9.9), 1);
                result.cooldown_time=NumberMaxDecimal(NumberRange(Number(formValues[2]), 0, 5), 1);
                VarTag.set(other[0], "behavior_melee_attack", result);
                VarTag.remove(other[0], "behavior_ranged_attack")
                this.behaviors_attackableTarget(player, other);
            }
            if(formValues[0]===2)
            {
                let result={};
                result.attack_radius=NumberMaxDecimal(NumberRange(Number(formValues[1]), 0, 9.9), 1);
                result.cooldown_time=NumberMaxDecimal(NumberRange(Number(formValues[2]), 0, 5), 1);
                VarTag.set(other[0], "behavior_ranged_attack", result);
                VarTag.remove(other[0], "behavior_melee_attack")
                this.behaviors_attackableTarget(player, other);
            }
            other[0].triggerEvent(`sync_component:behavior_melee_attack`);
            other[0].triggerEvent(`sync_component:behavior_ranged_attack`);

        });
        ui.dropdown("gc.npc.interface.behaviors.attackable_target.behavior_attack.type", ["gc.npc.interface.behaviors.attackable_target.behavior_attack.none", "gc.npc.interface.behaviors.attackable_target.behavior_attack.melee", "gc.npc.interface.behaviors.attackable_target.behavior_attack.ranged"], eventJSON.behavior_melee_attack?1:eventJSON.behavior_ranged_attack?2:0)
        ui.textField("gc.npc.interface.behaviors.attackable_target.behavior_attack.attack_radius", "0.0 ---- 9.9", `${behavior_attack.attack_radius}`)
        ui.textField("gc.npc.interface.behaviors.attackable_target.behavior_attack.cooldown_time", "0.0 ---- 5.0", `${behavior_attack.cooldown_time}`)
        ui.show(player, other);
    }
    static async behaviors_attackableTarget_damage(player, other, pag=1){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>
        {
            this.behaviors_attackableTarget(player, other);
        });
        ui.textField("gc.npc.interface.components.damage", "0 --- 999", `${eventJSON.damage>=0?eventJSON.damage:1}`, ({player, other, formValue})=>
        {
            VarTag.set(other[0], "damage", NumberMaxDecimal(NumberRange(Number(formValue), 0, 999)));
            other[0].triggerEvent(`sync_component:damage`);
        })
        ui.show(player, other);
    }
    static async behaviors_runFrom_behaviors(player, other)
    {
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let run_from = eventJSON.run_from||{priority:0, target:{type:"nothing",value:"nothing"}, max_dist:8}
        let ui= new interfaceModalForm("", ({player, other, formValues, canceled})=>
        {
            if(canceled===true){ this.behaviors_runFrom(player, other); return }
            if(formValues[0]===false){
                VarTag.remove(other[0], "run_from")
                other[0].triggerEvent(`sync_component:run_from`);
                this.behaviors_runFrom(player, other);
                return
            }
            run_from.priority=formValues[1];
            run_from.max_dist=NumberMaxDecimal(NumberRange(Number(formValues[2]||run_from.max_dist), 1, 8));
            VarTag.set(other[0], "run_from", run_from);
            other[0].triggerEvent(`sync_component:run_from`);
            this.behaviors_runFrom(player, other);
        });
        ui.toggle("gc.npc.interface.behavior", eventJSON.run_from===undefined?false:true)
        ui.slider("priority", 0, 5, 1, run_from.priority)
        ui.textField("max_dist", "1 ---- 8", `${run_from.max_dist}`)
        ui.show(player, other);
    }
    static async components_damage(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.damage", "0 --- 999", `${eventJSON.damage>=0?eventJSON.damage:1}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "damage", NumberMaxDecimal(NumberRange(Number(formValue), 0, 999)));
            other[0].triggerEvent(`sync_component:damage`);
        })
        ui.show(player, other);
    }
    static async components_health(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.health", "1 --- 999", `${eventJSON.health>=0?eventJSON.health:2}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "health", NumberMaxDecimal(NumberRange(Number(formValue), 1, 999)));
            other[0].triggerEvent(`sync_component:health`);
        })
		ui.toggle({translate:"gc.npc.interface.components.health.resetToMax"}, true, ({player, other, formValue})=>{
            if(!formValue)return
			EntityUtily(other[0]).getComponent.health.resetToMaxValue()
		});
		ui.slider({translate:"gc.npc.interface.components.health.boss_bar"}, 0, 100, 1, eventJSON.boss_bar, ({player, other, formValue})=>{
            VarTag.set(other[0], "boss_bar", formValue);
            other[0].triggerEvent(`sync_component:boss_bar`);
		});
        ui.show(player, other);
    }
    static async components_scale(player, other){
        await new Promise(e=>e())
        let eventJSON= VarTag.getObj(other[0]);
        let ui= new interfaceModalForm("", ({player, other})=>{
            this.components(player, other);
        });
        ui.textField("gc.npc.interface.components.scale", "0.01 --- 5.0", `${eventJSON.scale>=0?eventJSON.scale:1}`, ({player, other, formValue})=>{
            VarTag.set(other[0], "scale", NumberMaxDecimal(NumberRange(Number(formValue), 0.01, 5), 2));
            other[0].triggerEvent(`sync_component:scale`);
        })
        ui.show(player, other);
    }
}


export class interface_moveNPC{
    static default(player, other){
        let eventJSON= VarTag.getObj(other[0]);
        let config=eventJSON.config||{speed:0, detectY:-1}
        new interfaceActionForm("")
        .button("remove", "textures/ui/barrier.png", ({player,ui})=>{
            other[0].triggerEvent("gc:despawn");
        })
        .button("tags", "textures/ui/name_tag.png", ({player, other})=>{
            this.tags(player, other);
        })
        .button(`speed:§2 ${config.speed}`, "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.speed(player, other);
        })
        .button(`block detection:§2 ${config.detectY}`, "textures/ui/creator_glyph_color.png", ({player, other})=>{
            this.directionY(player, other);
        })
        .show(player, other)
    }
    static speed(player, other){
        let eventJSON= VarTag.getObj(other[0]);
        let config=eventJSON.config||{speed:0, detectY:-1}
        let ui= new interfaceModalForm("", ({other,cancelationReason,canceled,formValues,player})=>{
            if(canceled){this.default(player, other); return;}
            config.speed=Number(formValues[0])
            VarTag.set(other[0], "config", config)
            this.default(player, other)
        })
        ui.textField(`value:`, "0.0", `${config.speed}`)
        ui.show(player, other)
    }
    static directionY(player, other){
        let eventJSON= VarTag.getObj(other[0]);
        let config=eventJSON.config||{speed:0, detectY:-1}
        let ui= new interfaceModalForm("", ({other,cancelationReason,canceled,formValues,player})=>{
            if(canceled){this.default(player, other); return;}
            config.detectY=Number(formValues[0])
            VarTag.set(other[0], "config", config)
            this.default(player, other)
        })
        ui.textField(`value:`, "0", `${config.detectY}`)
        ui.show(player, other)
    }
    static tags(player, other){
        let ui = new interfaceActionForm("")
        ui.button("gc.npc.interface.back", "textures/ui/BackArrow.png", ({player, other})=>{
            this.default(player, other);
        })
        for(let i=0;i<100;i++){
            let thisTag=other[0].hasTag(`tag${i}`)
            ui.button(`tag${i}: ${thisTag}`, "textures/ui/name_tag.png", ({player, other})=>{
                if(thisTag)
                    other[0].removeTag(`tag${i}`)
                else
                    other[0].addTag(`tag${i}`)
                this.tags(player, other);
            })
        }
        ui.show(player, other)
    }
}
