import { DynamicPropertiesDefinition, Entity, Player, system, world } from "@minecraft/server"
import { CustomNPC_high_interfaces, CustomNPC_interfaces, CustomNPC_medium_interfaces, interface_moveNPC } from "./edit/interface";
import { AutoJSON, EntityToPlayer, EntityUtily, NumberMaxDecimal, NumberRange, VarTag } from "./outros/gc";
import { interfaceActionForm, interfaceModalForm } from "./outros/gc_interface";
import { DefinitionModifier } from "@minecraft/server";
import { serverForm } from "./serverForm";
import * as subpack from "./subpack" 


function scoreCreate(id){
	if(world.scoreboard.getObjective(id)===undefined||world.scoreboard.getObjective(id)===null){
		world.scoreboard.addObjective(id, id)
	}
}
let scoreList= [
	"npc_classic_skin_id",
	"npc_model_skin_id",
	"npc_animation_id"
];
world.afterEvents.worldInitialize.subscribe(()=>{
	for(let score of scoreList){
		scoreCreate(score)
	}
})

world.beforeEvents.dataDrivenEntityTriggerEvent.subscribe(e=>{
	let startWitch="sync_component:";
	if(e.entity.typeId!=="gc:npc")return
	if(!e.id.startsWith(startWitch))return
	//ex: e.id = "sync_component:teste"	

	//name = "teste"
	let name=e.id.substring(startWitch.length)
	//value= valor do "teste"
	let value=AutoJSON.stringify(VarTag.get(e.entity, name))

	//sincroniza a tag expecifica com component
	let component_groups= new DefinitionModifier()
	if(value===undefined)
		component_groups.setComponentGroupsToRemove([`gc:${name}`])
	else
		component_groups.setComponentGroupsToAdd([`gc:${name}__${value}`])
	e.setModifiers([component_groups]);	
})
world.afterEvents.dataDrivenEntityTriggerEvent.subscribe(({entity, id})=>{
	if(!entity.lifetimeState)return
	let startWitch="interact:serverform";
	if(entity.typeId!=="gc:npc")return
	if(!id.startsWith(startWitch))return

	let player=world.getPlayers({tags:["npc_interract"]})[0]
	let serverformData=VarTag.get(entity, "serverForm")
	let serverform=new serverForm()
	player.removeTag("npc_interract")
	serverform[serverformData.id](player, entity)
})
world.beforeEvents.dataDrivenEntityTriggerEvent.subscribe(async ({entity, id})=>{
	await new Promise(e=>e())
	if(!entity.lifetimeState)return
	let startWitch="property:";
	if(entity.typeId!=="gc:npc")return
	if(!id.startsWith(startWitch))return
	//ex: e.id = "sync_component:teste"	

	let event=id.substring(startWitch.length).split("__")
	VarTag.set(entity, event[0], AutoJSON.parse(event[1]))
})

world.afterEvents.entityHit.subscribe(async({entity,hitBlock,hitEntity})=>{
	if(!hitEntity)return

	if(hitEntity.typeId!=="gc:npc")return
	let item= EntityUtily(entity).equipment.getEquipment("mainhand")
	if(!item||item.typeId!=="gc:staff_edit"){
		let serverformData=VarTag.get(hitEntity, "serverForm")
		if(!serverformData)return
		if(!serverformData.attack)return
		let serverform=new serverForm()
		serverform[serverformData.id](entity, hitEntity)
	}
	if(!item)return
	if(item.typeId!=="gc:staff_edit")return
	if(subpack.default===0)
		CustomNPC_high_interfaces.default(entity, [hitEntity])
	if(subpack.default===1)
		CustomNPC_medium_interfaces.default(entity, [hitEntity])
})
world.afterEvents.entityHit.subscribe(async({entity,hitBlock,hitEntity})=>{
	if(!hitEntity)return
	if(hitEntity.typeId!=="gc:move_npc")return
	let item= EntityUtily(entity).equipment.getEquipment("mainhand")
	if(!item)return
	if(item.typeId==="gc:staff_edit")
		interface_moveNPC.default(entity, [hitEntity])
})


world.afterEvents.worldInitialize.subscribe(e=>{
	let propertires= new DynamicPropertiesDefinition()
	propertires.defineString(`AutoTag${0}`, 10000-10)
	e.propertyRegistry.registerWorldDynamicProperties(propertires)
})


function MoveNPCSystemCentralized(entity, speed){
	//2 == z+
	//3 == z-
	//4 == x+
	//5 == x-

	let location={
		x:NumberMaxDecimal(entity.location.x, 2),
		y:NumberMaxDecimal(entity.location.y, 2),
		z:NumberMaxDecimal(entity.location.z, 2)
	};
	if(Math.abs(location.x*100)%100==50&&Math.abs(location.z*100)%100==50) 
	{
		entity.removeTag("x+"); entity.removeTag("x-"); entity.removeTag("moving");
		entity.removeTag("z+"); entity.removeTag("z-"); entity.removeTag("moving");
	}
	console.warn(Math.abs(entity.location.z))
	if(entity.hasTag("z+"))
	{
		location.z+=speed;
		entity.teleport(location);
	}
	if(entity.hasTag("z-"))
	{
		location.z+=-speed;
		entity.teleport(location);
	}
	if(entity.hasTag("x+"))
	{
		location.x+=speed;
		entity.teleport(location);
	}
	if(entity.hasTag("x-"))
	{
		location.x+=-speed;
		entity.teleport(location);
	}
}

/**
 * 
 * @param {Entity} entity 
 * @param {Number} facing_direction 
 */
function MoveNPCStartSystemCentralized(entity, facing_direction, speed){
	//2 == z+
	//3 == z-
	//4 == x+
	//5 == x-
	let location={
		x:NumberMaxDecimal(entity.location.x, 2),
		y:NumberMaxDecimal(entity.location.y, 2),
		z:NumberMaxDecimal(entity.location.z, 2)
	};

	// console.warn(NumberMaxDecimal((location.z)%1, 2))
	// console.warn((facing_direction==3&&!entity.hasTag("z-")))
	// console.warn(entity.hasTag("z-"))
	if(facing_direction==2&&!entity.hasTag("moving"))
	{
		location.z+=speed;
		entity.teleport(location);
		console.warn("start")
		entity.addTag("moving")
		entity.addTag("z+")
	}
	if(facing_direction==3&&!entity.hasTag("moving"))
	{
		location.z+=-speed;
		entity.teleport(location);
		entity.addTag("moving")
		entity.addTag("z-")
	}
	if(facing_direction==4&&!entity.hasTag("moving"))
	{
		location.x+=speed;
		entity.teleport(location);
		entity.addTag("moving")
		entity.addTag("x+")
	}
	if(facing_direction==5&&!entity.hasTag("moving"))
	{
		location.x+=-speed;
		entity.teleport(location);
		entity.addTag("moving")
		entity.addTag("x-")
	}
}
function MoveNPCSystemSimple(entity, facing_direction, speed){
	let location={
		x:NumberMaxDecimal(entity.location.x, 2),
		y:NumberMaxDecimal(entity.location.y, 2),
		z:NumberMaxDecimal(entity.location.z, 2)
	};

	if(facing_direction==2)
	{
		location.z+=speed;
		entity.teleport(location);
	}
	if(facing_direction==3)
	{
		location.z+=-speed;
		entity.teleport(location);
	}
	if(facing_direction==4)
	{
		location.x+=speed;
		entity.teleport(location);
	}
	if(facing_direction==5)
	{
		location.x+=-speed;
		entity.teleport(location);
	}
}

system.runInterval(()=>{
	let moveNPCs= world.getDimension("overworld").getEntities({type:"gc:move_npc"})
	for(let moveNPC of moveNPCs)
	{
		if(moveNPC.lifetimeState==="unloaded")continue
		let eventJSON= VarTag.getObj(moveNPC);
		let config=eventJSON.config||{speed:0, detectY:-1}
		let blockLocation= moveNPC.location
		blockLocation.y+=config.detectY;
		let blockDown= moveNPC.dimension.getBlock(blockLocation)
		if(blockDown===undefined)continue
		if(blockDown.typeId!="minecraft:magenta_glazed_terracotta")continue
		MoveNPCSystemSimple(moveNPC, blockDown.permutation.getState("facing_direction"), config.speed)
	}
})




class RunTime{
	/**
	 * 
	 * @param {({elapsedTime, stop})=>{}} callback 
	 * @param {*} deley 
	 */
	static async loop (callback, deley=0){
		let isRunning=true
		let stop=function(){
			isRunning=false
		}
		let deleyTime=new Date()
		let startTime=new Date()
		while (isRunning) {
			const currentTime = new Date();
			const elapsedTime = currentTime.getTime() - startTime.getTime();
			const currentDeley= currentTime.getTime() - deleyTime.getTime()
			if(currentDeley>=deley){
				deleyTime= new Date()
				callback({elapsedTime, stop});
			}
			await new Promise(e=>e())
		}
	}
	/**
	 * 
	 * @param {({elapsedTime})=>{}} callback 
	 * @param {Number} timeout 
	 */
	static async setTimeout(callback, timeout){
		let isRunning=true
		let startTime=new Date()
		while (isRunning) {
			const currentTime = new Date();
			const elapsedTime = currentTime.getTime() - startTime.getTime();
			if(timeout!=undefined&&elapsedTime>=timeout){
				callback({elapsedTime});
				isRunning=false
			}
			await new Promise(e=>e())
		}
	}
}
