import { EntityEquipmentInventoryComponent, EntityHealthComponent } from "@minecraft/server";
import { Entity, system, world } from "@minecraft/server";

class TickLoop
{
    static _loopCallbacks = [];
    static _initialized = false;

    static Subscribe(callback)
    {
        if(!TickLoop._initialized)
        {
            TickLoop._initialized = true;
            system.runInterval(TickLoop.Loop);
        }

        TickLoop._loopCallbacks.push(callback);
				return callback
    }

    static Unsubscribe(callback)
    {
        const index = this._loopCallbacks.indexOf(callback);

        if(index == -1 ) return;

        TickLoop._loopCallbacks.splice(index, 1);
    }

    static async Loop()
    {
        for(let i = 0 ; i < TickLoop._loopCallbacks.length; i++)
        {
            const cb = TickLoop._loopCallbacks[i];

            await cb();
        }
    }
}
export class runTick{
    static _deleyCount = 0;
    static run(callback)
    {
        system.runTimeout(()=>{callback(); this._deleyCount+=-1}, this._deleyCount)
        this._deleyCount++;
    }
    static loop= TickLoop
}
export class VarTag
{
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} tag 
     * @returns 
     */
    static get(entity, tag)
    {
        let tags= entity.getTags();
        let FindTag= `,"${tag}":`;
        let parse;
        for(let tag of tags)
        {
            if(tag.startsWith(FindTag))
            {
                parse=JSON.parse(tag.substring(FindTag.length));
                break;
            }
        }
        return parse
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @returns 
     */
    static getObj(entity)
    {
        let obj='{"null":0';
        entity.getTags().forEach(tag=>{
            let Var= tag.startsWith(',"') ? tag : undefined;
            if(Var!==undefined)
                obj+=Var;
        });
        obj+='}';
        return JSON.parse(obj);
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} tag
     * @param {*} value
     */
    static set(entity, tag, value)
    {
        if(value===undefined) return
        entity.removeTag(`,"${tag}":${JSON.stringify(this.get(entity, tag))}`)
        entity.addTag(`,"${tag}":${JSON.stringify(value)}`)
        return value
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} tag
     */
    static remove(entity, tag)
    {
        return entity.removeTag(`,"${tag}":${JSON.stringify(this.get(entity, tag))}`)
    }
}
export class EntityScore{
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} defaultValue 
     */
    static get(entity, id, defaultValue=0)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=defaultValue;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return scoreValue}
        if(ScoreIdentity===undefined){return scoreValue}
        try{scoreValue=ScoreIdentity.getScore(objective)} catch(e){}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static set(entity, id, value)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=value;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(scoreValue===undefined){console.warn("ô mongol, esqueceu de falar o valor"); return }
        if(ScoreIdentity===undefined){
            entity.runCommand(`scoreboard players set @s ${id} ${scoreValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return scoreValue
        }
        if(!objective.setScore(ScoreIdentity, scoreValue)){console.warn("de alguma forma deu erro ._.")}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static add(entity, id, value=0)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(entity, id);
        let newValue=scoreValue+value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            entity.runCommand(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static remove(entity, id, value)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(entity, id);
        let newValue=scoreValue-value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            entity.runCommand(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue

    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     */
    static reset(entity, id)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return false}
        if(ScoreIdentity===undefined){console.warn("a caralha da entidade nem tem valor scoreboard"); return false}
        return entity.scoreboardIdentity.removeFromObjective(objective)
    }
}
export class EntityScoreAsync{
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} defaultValue 
     */
    static get(entity, id, defaultValue=0)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=defaultValue;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return scoreValue}
        if(ScoreIdentity===undefined){return scoreValue}
        try{scoreValue=ScoreIdentity.getScore(objective)} catch(e){}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static async set(entity, id, value)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=value;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(scoreValue===undefined){console.warn("ô mongol, esqueceu de falar o valor"); return }
        if(ScoreIdentity===undefined){
            await entity.runCommandAsync(`scoreboard players set @s ${id} ${scoreValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return scoreValue
        }
        if(!objective.setScore(ScoreIdentity, scoreValue)){console.warn("de alguma forma deu erro ._.")}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static async add(entity, id, value=0)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(entity, id);
        let newValue=scoreValue+value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            await entity.runCommandAsync(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    static async remove(entity, id, value)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(entity, id);
        let newValue=scoreValue-value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            await entity.runCommandAsync(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue

    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     */
    static reset(entity, id)
    {
        let ScoreIdentity=entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return false}
        if(ScoreIdentity===undefined){console.warn("a caralha da entidade nem tem valor scoreboard"); return false}
        return entity.scoreboardIdentity.removeFromObjective(objective)
    }
}
/**
 * 
 * @param {Number} value 
 * @param {Number} min 
 * @param {Number} max 
 * @returns 
 */
export function NumberRange(value, min, max){
    if(min>max) {console.warn(`animal, burrão, min:${min} > max:${max}`); return}
    if(value>=min&&value<=max) return value
    if(value<min) return min
    if(value>max) return max
    return min
}
/**
 * 
 * @param {Number} value 
 * @param {Number} max 
 * @returns 
 */
export function NumberMaxDecimal(value, max=0){
    return Number(value.toFixed(max))
}
export function booleanDefault(value, defaultValue){
    if(typeof(value)!=="boolean") return defaultValue
    return value===false?false:value===true?true:defaultValue
}
/**
 * 
 * @param {Entity} entity 
 */
export function EntityToPlayer(entity){
    return world.getPlayers({name:entity.nameTag})[0]
}
/**
 * 
 * @param {Entity} entity 
 */
export function EntityGetEquipment(entity){
    return EntityEquipmentInventoryComponentFormat(entity.getComponent("minecraft:equipment_inventory"))
}
export class EntityUtilyScoreboard{
    /**
     * 
     * @param {Entity} entity 
     */
    constructor(entity){
        this.entity=entity
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} defaultValue 
     */
    get(id, defaultValue=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=defaultValue;
        if(objective===undefined)
        {
            console.warn("poha, o objective não existe krai");
            return scoreValue
        }
        if(ScoreIdentity===undefined)
            return scoreValue;
        scoreValue=ScoreIdentity.getScore(objective)
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    set(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=value;
        if(objective===undefined)
        {
            console.warn("poha, o objective não existe krai");
            return 
        }
        if(ScoreIdentity===undefined)
        {
            console.warn("a entidade não tem scoreboard, adicione algum ou use o metodo Async"); 
            return scoreValue
        }
        if(!objective.setScore(ScoreIdentity, scoreValue))
            console.warn("de alguma forma deu erro ._.")
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    add(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(this.entity, id);
        if(scoreValue===undefined) return
        let newValue=scoreValue+value
        if(objective===undefined)
        {
            console.warn("poha, o objective não existe krai"); 
            return
        }
        if(ScoreIdentity===undefined)
        {
            console.warn("a entidade não tem scoreboard, adicione algum ou use o metodo Async"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue))
            console.warn("de alguma forma deu erro ._.")
        return newValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    remove(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(this.entity, id);
        if(scoreValue===undefined) return
        let newValue=scoreValue-value
        if(objective===undefined)
        {
            console.warn("poha, o objective não existe krai"); 
            return
        }
        if(ScoreIdentity===undefined)
        {
            console.warn("a entidade não tem scoreboard, adicione algum ou use o metodo Async"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue))
            console.warn("de alguma forma deu erro ._.")
        return newValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     */
    reset(id)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        if(objective===undefined)
        {
            console.warn("poha, o objective não existe krai"); 
            return false
        }
        if(ScoreIdentity===undefined)
        {
            console.warn("a caralha da entidade nem tem valor scoreboard"); 
            return false
        }
        return this.entity.scoreboardIdentity.removeFromObjective(objective)
    }
}
export class EntityUtilyScoreboardAsync{
    /**
     * 
     * @param {Entity} entity 
     */
    constructor(entity){
        this.entity=entity
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} defaultValue 
     */
    get(id, defaultValue=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=defaultValue;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return scoreValue}
        if(ScoreIdentity===undefined){return scoreValue}
        try{scoreValue=ScoreIdentity.getScore(objective)} catch(e){}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    async set(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=value;
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(scoreValue===undefined){console.warn("ô mongol, esqueceu de falar o valor"); return }
        if(ScoreIdentity===undefined){
            await this.entity.runCommandAsync(`scoreboard players set @s ${id} ${scoreValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return scoreValue
        }
        if(!objective.setScore(ScoreIdentity, scoreValue)){console.warn("de alguma forma deu erro ._.")}
        return scoreValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    async add(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(this.entity, id);
        let newValue=scoreValue+value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            await this.entity.runCommandAsync(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue
    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     * @param {Number} value 
     */
    async remove(id, value=0)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        let scoreValue=this.get(this.entity, id);
        let newValue=scoreValue-value
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return }
        if(ScoreIdentity===undefined){
            await this.entity.runCommandAsync(`scoreboard players set @s ${id} ${newValue}`)
            //console.warn("é foda, mas a entidade precisa de algum valor em algum scoreboard pra funfa essa poha"); 
            return newValue
        }
        if(!objective.setScore(ScoreIdentity, newValue)){console.warn("de alguma forma deu erro ._.")}
        return newValue

    }
    /**
     * 
     * @param {Entity.prototype} entity 
     * @param {String} id 
     */
    reset(id)
    {
        let ScoreIdentity=this.entity.scoreboardIdentity;
        let objective= world.scoreboard.getObjective(id);
        if(objective===undefined){console.warn("poha, o objective não existe krai"); return false}
        if(ScoreIdentity===undefined){console.warn("a caralha da entidade nem tem valor scoreboard"); return false}
        return this.entity.scoreboardIdentity.removeFromObjective(objective)
    }
}
/**
 * @param {Entity} entity 
 * @returns 
 */
export function EntityUtily(entity){
    let obj={
        toPlayer:()=>EntityToPlayer(entity),
        scoreboard:new EntityUtilyScoreboard(entity),
        scoreboardAsync:new EntityUtilyScoreboardAsync(entity),
        equipment:EntityGetEquipment(entity),
        getComponent:{
            health: entity.getComponent("minecraft:health")
        }
    }
    return EntityUtilyFormat(obj)
}
export class AutoJSON{
    static parse(value){
        let parce=value;
        try{parce=JSON.parse(value)}catch(e){}
        return parce
    }
    static stringify(value){
        if(value===undefined) return
        let string=value;
        try{string=JSON.parse(value)}catch(e){}
        if(typeof(string)==="object")
            return JSON.stringify(string);
        return `${string}`
    }
}


/**
 * 
 * @param {EntityHealthComponent} EntityHealthComponent 
 * @returns 
 */
function EntityHealthComponentFormat(EntityHealthComponent){
    return EntityHealthComponent
}
/**
 * @param {EntityEquipmentInventoryComponent} any 
 */
function EntityEquipmentInventoryComponentFormat(any){return any}
/**
 * @param {EntityUtilyData} any 
 * @returns 
 */
function EntityUtilyFormat(any){return any}

class EntityUtilyGetComponentData{
    health=EntityHealthComponent.prototype
}

class EntityUtilyData{
    toPlayer= ()=>EntityToPlayer()
    scoreboard= EntityUtilyScoreboard.prototype
    scoreboardAsync= EntityUtilyScoreboardAsync.prototype
    equipment= EntityEquipmentInventoryComponent.prototype
    getComponent= EntityUtilyGetComponentData.prototype
}




function TranslateRawText(){
    let text={rawtext:[]}
    for(let argument of arguments)
        text.rawtext.push({translate:argument})
    return text
}